local GradeVar = {
	Grade_Tier01 = 0;
	Grade_Tier02 = 1;
	Grade_Tier03 = 2;
	Grade_Tier04 = 3;
	Grade_Tier05 = 4;
	Grade_Tier06 = 5;
	Grade_Tier07 = 6;
	Grade_Tier08 = 7;
	Grade_Tier09 = 8;
	Grade_Tier10 = 9;
	Grade_Tier11 = 10;
	Grade_Tier12 = 11;
	Grade_Tier13 = 12;
	Grade_Tier14 = 13;
	Grade_Tier15 = 14;
	Grade_Tier16 = 15;
	Grade_Tier17 = 16;
	Grade_Tier18 = 17;
	Grade_Tier19 = 18;
	Grade_Tier20 = 19;
	Grade_Failed = 20;
};

local _MinCombo_=GetUserPref_Theme("UserMinCombo");
local MinCombo=(_MinCombo_=='TapNoteScore_W3') and 3 or ((_MinCombo_=='TapNoteScore_W1') and 1 or ((_MinCombo_=='TapNoteScore_W2') and 2 or 4));
local wheelmode="";
if GetUserPref_Theme("UserWheelMode") == 'Jacket->Banner' then
	wheelmode = "JBN"
elseif GetUserPref_Theme("UserWheelMode") == 'Jacket->BG' then
	wheelmode = "JBG"
elseif GetUserPref_Theme("UserWheelMode") == 'Banner->Jacket' then
	wheelmode = "BNJ"
elseif GetUserPref_Theme("UserWheelMode") == 'BG->Jacket' then
	wheelmode = "BGJ"
else
	wheelmode = "JBN"
end;

local judtable={"W1","W2","W3","W4","W5","Miss","Held","MaxCombo"};

local t = Def.ActorFrame{};

t[#t+1]=EXF_ScreenEvaluation();

local eva_w1=0;
local eva_w2=0;
local eva_w3=0;
local eva_w4=0;
local eva_w5=0;
local eva_ms=0;
local eva_ok=0;
local eva_ng=0;
local eva_tt=0;
local eva_hr=0;	-- [ja] ロングノートの数 

-- [ja] W1～Missの数を返す(通常用) 
local function GetSongJud(pss)
	local combo   = pss:GetCurrentCombo();
	local okcount = pss:GetHoldNoteScores('HoldNoteScore_Held');
	local mscount = pss:GetTapNoteScores('TapNoteScore_Miss');
	local w5count = pss:GetTapNoteScores('TapNoteScore_W5');
	local w4count = pss:GetTapNoteScores('TapNoteScore_W4');
	local w3count = pss:GetTapNoteScores('TapNoteScore_W3');
	local w2count = pss:GetTapNoteScores('TapNoteScore_W2');
	local w1count = pss:GetTapNoteScores('TapNoteScore_W1');
	local eva_jud={w1count,w2count,w3count,w4count,w5count,mscount,okcount,combo};
	return eva_jud;
end;

-- [ja] W1～Missの数を返す(ネット対戦用) 
local function GetNetJud(pn)
	local p=((pn=='PlayerNumber_P1') and 1 or 2);
	local combo=tonumber(SCREENMAN:GetTopScreen():GetChild("MaxComboNumberP"..p):GetText());
	local okcount=tonumber(SCREENMAN:GetTopScreen():GetChild("HeldNumberP"..p):GetText());
	local mscount=tonumber(SCREENMAN:GetTopScreen():GetChild("MissNumberP"..p):GetText());
	local w5count=tonumber(SCREENMAN:GetTopScreen():GetChild("W5NumberP"..p):GetText());
	local w4count=tonumber(SCREENMAN:GetTopScreen():GetChild("W4NumberP"..p):GetText());
	local w3count=tonumber(SCREENMAN:GetTopScreen():GetChild("W3NumberP"..p):GetText());
	local w2count=tonumber(SCREENMAN:GetTopScreen():GetChild("W2NumberP"..p):GetText());
	local w1count=tonumber(SCREENMAN:GetTopScreen():GetChild("W1NumberP"..p):GetText());
	local eva_jud={w1count,w2count,w3count,w4count,w5count,mscount,okcount,combo};
	return eva_jud;
end;

local function GetEvaluationFullCombo(pss)
	local jud=GetSongJud(pss);
	local j_ng=pss:GetHoldNoteScores('HoldNoteScore_LetGo');
	local j_ht=pss:GetTapNoteScores('TapNoteScore_HitMine');
	local grade=pss:GetGrade();
	local tandh=pss:GetRadarPossible():GetValue('RadarCategory_TapsAndHolds');
	local total=pss:GetRadarPossible():GetValue('RadarCategory_Jumps')+tandh;
	local j_chk=jud[6]+jud[5]+j_ng+j_ht;
	local fc;
	if GradeVar[grade]~=20 and jud[8]>=total then
		if j_chk+jud[4]+jud[3]+jud[2]==0 then
			fc="JudgmentLine_W1";
		elseif j_chk+jud[4]+jud[3]==0 then
			fc="JudgmentLine_W2";
		elseif j_chk+jud[4]==0 then
			fc="JudgmentLine_W3";
		elseif j_chk==0 then
			fc="JudgmentLine_W4";
		end;
	else
		fc=nil;
	end;
	return fc;
end;

local eval_jud={};	-- [ja] スコア収納用 

local SongOrCourse;

local eva_hr=0;
local eva_tt=0;
local eva_ng=0;
local sys_key=false;

t[#t+1]=Def.ActorFrame{
	OnCommand=function(self)
		self:addy(-SCREEN_HEIGHT);
		self:decelerate(_TT.S_IN);
		self:addy(SCREEN_HEIGHT);
		--[[
		local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1);
		if pss then
			_SYS("L"..pss:GetPersonalHighScoreIndex().."\nM"
				..pss:GetMachineHighScoreIndex().."\n"
				..(pss:IsDisqualified() and "T" or "F"));
		end;
		--]]
		sys_key=true;
	end;
	CodeCommand=function(self,params)
		if sys_key and IsPopupExDialog() and (params.Name=='ShowPopup' or params.Name=='ShowPopup2') then
			self:queuecommand("Dialog");
		end;
	end;
	DialogCommand=function(self)
		SCREENMAN:AddNewScreenToTop("ScreenDialog");
	end;
	OffCommand=function(self)
		self:accelerate(_TT.S_OUT);
		self:addy(SCREEN_HEIGHT);
	end;
	Def.Actor{
		InitCommand=function(self)
			if not GAMESTATE:IsCourseMode() then
				SongOrCourse=_SONG();
			else
				SongOrCourse=GAMESTATE:GetCurrentCourse();
			end;
		end;
		UpdateNetEvalStatsMessageCommand=function(self,params)
			local st=params.Steps;
			eva_hr=st:GetRadarValues(pn):GetValue('RadarCategory_Holds')+st:GetRadarValues(pn):GetValue('RadarCategory_Rolls');
			eva_tt=math.max(st:GetRadarValues(pn):GetValue('RadarCategory_TapsAndHolds'),1);
			self:sleep(0.01);
			self:queuecommand("GetNetEvalStats");
		end;
		GetNetEvalStatsCommand=function(self)
			eval_jud=GetNetJud(GAMESTATE:GetMasterPlayerNumber());
			eva_ng=eva_hr-eval_jud[7];
		end;
	};
	StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
	Def.Quad{
		InitCommand=function(self)
			self:zoomto(192,192);
			self:diffuse(Color("Black"));
			self:diffusealpha(0.5);
			self:x(SCREEN_CENTER_X+_HS2);
			self:y(SCREEN_TOP+160);
		end;
	};
	Def.Banner{
		InitCommand=function(self)
			if SongOrCourse then
				if not GAMESTATE:IsCourseMode() then
					local tmp={};
					tmp=GetBannerStat(SongOrCourse,wheelmode);
					self:Load(tmp[1]);
				else
					self:Load(GetCourseGPath(SongOrCourse));
				end;
			else
				self:Load(THEME:GetPathG("Common fallback","jacket"));
			end;
			self:scaletofit(0,0,192,192);
			self:x(SCREEN_CENTER_X+_HS2);
			self:y(SCREEN_TOP+160);
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:diffuse(D3Color("Text"));
			self:strokecolor(Color("White"));
			self:maxwidth(182);
			if SongOrCourse then
				if not GAMESTATE:IsCourseMode() then
					local tmp={};
					tmp=GetBannerStat(SongOrCourse,wheelmode);
					if tmp[1]==THEME:GetPathG("Common fallback","jacket")
						or tmp[1]==THEME:GetPathG("Common fallback","banner")
						or tmp[1]==THEME:GetPathG("Common fallback","background") then
						self:settext(SongOrCourse:GetDisplayFullTitle());
					end;
				else
					local tmp=GetCourseGPath(SongOrCourse);
					if tmp=="" or tmp==THEME:GetPathG("Common fallback","jacket")
						or tmp==THEME:GetPathG("Common fallback","banner")
						or tmp==THEME:GetPathG("Common fallback","background") then
						self:settext(SongOrCourse:GetDisplayFullTitle());
					end;
				end;
			else
				self:settext(SongOrCourse:GetDisplayFullTitle());
			end;
			self:x(SCREEN_CENTER_X+_HS2);
			self:y(SCREEN_TOP+160);
		end;
	};
	StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
	StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			if getenv("ExUltimateLife") then
				self:diffuse(Color("Black"));
			else
				self:diffuse(D3Color("Text"));
			end;
			self:strokecolor(Color("White"));
			self:zoom(0.75);
			self:maxwidth(280/0.75)
			self:x(SCREEN_CENTER_X+_HS2);
			self:y(SCREEN_CENTER_Y+40);
			self:skewx(-0.1);
			local stl=GAMESTATE:GetCurrentStyle():GetStepsType();
			if stl=='StepsType_Dance_Single' then
				if GAMESTATE:GetNumPlayersEnabled()<=1 then
					self:settext(THEME:GetString("StepsType","dance-single"));
				else
					self:settext(THEME:GetString("StepsType","dance-couple"));
				end;
			elseif stl=='StepsType_Dance_Double' then
				self:settext(THEME:GetString("StepsType","dance-double"));
			else
				self:settext("");
			end;
		end;
	};
	LoadFont("Common Normal")..{
		InitCommand=function(self)
			self:settext(THEME:GetString("ScreenEvaluation","ShowMessage"));
			self:zoom(0.66);
			self:strokecolor(Color("White"));
			self:diffuseblink();
			self:effectcolor1(D3Color("Text"));
			self:effectcolor2(D3Color("Light")[1],D3Color("Light")[2],D3Color("Light")[3],0.66);
			self:effecttiming(0.1,0,0.2,0);
			self:x(SCREEN_CENTER_X+_HS2);
			self:y(SCREEN_HEIGHT-40);
			self:visible(IsPopupExDialog());
		end;
		DialogCommand=function(self)
			self:visible(false);
		end;
	};
};

for p=1,2 do
	local pn = (p==1) and PLAYER_1 or PLAYER_2;
	local StepsOrTrail;
	local dif;
	local ss;
	local pss;
	local pct=0.0;
	if GAMESTATE:IsPlayerEnabled(pn) then
		t[#t+1]=Def.ActorFrame{
			OnCommand=function(self)
				self:addy(-SCREEN_HEIGHT);
				self:decelerate(_TT.S_IN);
				self:addy(SCREEN_HEIGHT);
			end;
			OffCommand=function(self)
				self:accelerate(_TT.S_OUT);
				self:addy(SCREEN_HEIGHT);
			end;
			Def.Actor{
				InitCommand=function(self)
					if not GAMESTATE:IsCourseMode() then
						StepsOrTrail=GAMESTATE:GetCurrentSteps(pn);
					else
						StepsOrTrail=GAMESTATE:GetCurrentTrail(pn);
					end;
					dif = StepsOrTrail:GetDifficulty();
					ss = STATSMAN:GetCurStageStats();
					pss = ss:GetPlayerStageStats(pn);
					if pss then
						pct = pss:GetPercentDancePoints();
					end;
					eval_jud=GetSongJud(pss);
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and SCREEN_CENTER_X+_HS2-120 or SCREEN_CENTER_X+_HS2+120);
					self:horizalign((pn==PLAYER_1) and right or left);
					self:y(SCREEN_TOP+30);
					self:diffuse(D3Color("Text"));
					self:strokecolor(Color("White"));
					self:zoom(1.3);
					self:skewx(-0.1);
					self:settext("Player"..p);
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1X")
						or THEME:GetMetric("ScreenEvaluation","GradeP2X"));
					self:y(SCREEN_CENTER_Y+29);
					self:shadowlength(1);
					self:maxwidth(SCREEN_CENTER_X-180);
					self:zoom(0.9);
					self:skewx(-0.1);
					if not GAMESTATE:IsCourseMode() then
						self:diffuse(_DifficultyCOLOR(dif));
						self:settextf("%s",string.upper(_DifficultyNAME(dif)));
					else
						self:diffuse(ColorLightTone2(CustomDifficultyToColor(dif)));
						self:settextf("%s",string.upper(ToEnumShortString(dif)));
					end;
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					if params.Difficulty then
						self:diffuse(_DifficultyCOLOR(params.Difficulty));
						self:settextf("%s",string.upper(_DifficultyNAME(params.Difficulty)));
					end;
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1X")+80
						or THEME:GetMetric("ScreenEvaluation","GradeP2X")+80);
					self:horizalign(right);
					self:y(SCREEN_BOTTOM-60);
					self:maxwidth(SCREEN_CENTER_X-180);
					self:zoom(0.8);
					self:diffuse(D3Color("Text"));
					self:strokecolor(Color("White"));
					self:settext(FormatPercentScore(pct));
						--[[
						if pct == 1 then
							self:settext("100%");
						else
							self:settext(FormatPercentScore(pct));
						end;
						--]]
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					self:sleep(0.01);
					self:queuecommand("GetNetEvalStats");
				end;
				GetNetEvalStatsCommand=function(self)
					local dp=0.0;
					if eval_jud[1] then
						dp=(eval_jud[1]*3+eval_jud[2]*2+eval_jud[3]+eval_jud[7]*3)/((eva_tt+eva_hr)*3);
					end;
					self:settext(FormatPercentScore(dp));
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1X")-85
						or THEME:GetMetric("ScreenEvaluation","GradeP2X")-85);
					self:horizalign(left);
					self:y(SCREEN_BOTTOM-60);
					self:maxwidth(SCREEN_CENTER_X-180);
					self:zoom(0.6);
					self:skewx(-0.1);
					self:diffuse(D3Color("Text"));
					self:strokecolor(Color("White"));
					if PROFILEMAN:IsPersistentProfile(pn) then
						-- player profile
						profile = PROFILEMAN:GetProfile(pn);
					else
						-- machine profile
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(_SONG(),GAMESTATE:GetCurrentSteps(pn));
					local scores = scorelist:GetHighScores();
					if pct>=GetScoreData(scores,"dp") then
						self:settext("NewRecord!!");
					else
						self:settext("");
					end;
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					self:settext("");
				end;
			};
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","PlayerOptionsP1X")
						or THEME:GetMetric("ScreenEvaluation","PlayerOptionsP2X"));
					self:y((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","PlayerOptionsP1Y")
						or THEME:GetMetric("ScreenEvaluation","PlayerOptionsP2Y"));
					self:maxwidth(SCREEN_CENTER_X-180);
					self:zoom(0.5);
					self:skewx(-0.1);
					self:diffuse(D3Color("Text"));
					self:strokecolor(Color("White"));
					self:diffusealpha(0.5);
					local t_opt=split(",",GAMESTATE:GetPlayerState(pn):GetPlayerOptionsString('ModsLevel_Stage'));
					local s_opt="";
					for i=1,#t_opt do
						s_opt=s_opt.."\n"..t_opt[i];
					end;
					self:settext(s_opt);
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					if params.PlayerOptions then
						local t_opt=split(",",params.PlayerOptions);
						local s_opt="";
						for i=1,#t_opt do
							s_opt=s_opt.."\n"..t_opt[i];
						end;
						self:settext(s_opt);
					end;
				end;
			};
			--[[
			Def.ActorProxy{
				BeginCommand=function(self)
					local grade = SCREENMAN:GetTopScreen():GetChild('GradeP'..p);
					self:SetTarget(grade);
				end;
			};
			--]]
			Def.Sprite{
				InitCommand=function(self)
					local pss=STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
					local gr=pss:GetGrade();
					self:Load(THEME:GetPathG("GradeDisplayEval",ToEnumShortString(gr)));
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1X")
						or THEME:GetMetric("ScreenEvaluation","GradeP2X"));
					self:y((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1Y")
						or THEME:GetMetric("ScreenEvaluation","GradeP2Y"));
				end;
				OnCommand=function(self)
					self:diffusealpha(0);
					self:zoom(3);
					self:sleep(_TT.S_IN);
					self:accelerate(0.5);
					self:zoom(1);
					self:diffusealpha(1);
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					if params.Grade then
						local gr=Grade[1+params.Grade];
						self:Load(THEME:GetPathG("GradeDisplayEval",ToEnumShortString(gr)));
					end;
				end;
			};
			Def.Sprite{
				InitCommand=function(self)
					self:x((pn==PLAYER_1) and
						THEME:GetMetric("ScreenEvaluation","GradeP1X")+60
						or THEME:GetMetric("ScreenEvaluation","GradeP2X")+60);
					self:y(SCREEN_CENTER_Y+57);
					if pss:GetScore()>0 then
						local fc=GetEvaluationFullCombo(pss);
						if fc=="JudgmentLine_W1" then
							self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
							self:diffuse(GameColor.Judgment["JudgmentLine_W1"]);
							self:zoom(2.5/2);
						elseif fc=="JudgmentLine_W2" then
							self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
							self:diffuse(GameColor.Judgment["JudgmentLine_W2"]);
							self:zoom(2.2/2);
						elseif fc=="JudgmentLine_W3" then
							self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x FullCombo"));
							self:diffuse(GameColor.Judgment["JudgmentLine_W3"]);
							self:zoom(2.0/2);
						elseif fc=="JudgmentLine_W4" then
							self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","2x GoodFullCombo"));
							self:diffuse(GameColor.Judgment["JudgmentLine_W4"]);
							self:zoom(2.5/2);
							self:y(SCREEN_CENTER_Y+65);
						else
							self:Load(THEME:GetPathG("","_blank"));
							self:zoom(0);
							self:diffuse(1.0,1.0,1.0,0);
						end;
					else
						self:Load(THEME:GetPathG("","_blank"));
						self:zoom(0);
						self:diffuse(1.0,1.0,1.0,0);
					end;
				end;
				OnCommand=function(self)
					self:diffusealpha(0);
					self:sleep(_TT.S_IN+0.5);
					self:accelerate(0.3);
					self:diffusealpha(1);
				end;
				UpdateNetEvalStatsMessageCommand=function(self,params)
					self:sleep(0.01);
					self:queuecommand("GetNetEvalStats");
				end;
				GetNetEvalStatsCommand=function(self)
					if eval_jud[1] then
						if eva_ng<=0 and eval_jud[6]<=0 and eval_jud[5]<=0 
							and (eval_jud[4]>0 or eval_jud[3]>0 or eval_jud[2]>0 or eval_jud[1]>0) then
							if eval_jud[4]<=0 and eval_jud[3]<=0 and eval_jud[2]<=0 then
								self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","FullCombo"));
								self:diffuse(GameColor.Judgment["JudgmentLine_W1"]);
								self:zoom(2.5);
							elseif eval_jud[4]<=0 and eval_jud[3]<=0 and MinCombo>=2 then
								self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","FullCombo"));
								self:diffuse(GameColor.Judgment["JudgmentLine_W2"]);
								self:zoom(2.2);
							elseif eval_jud[4]<=0 and MinCombo>=3 then
								self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","FullCombo"));
								self:diffuse(GameColor.Judgment["JudgmentLine_W3"]);
								self:zoom(2.0);
							elseif MinCombo>=4 then
								self:Load(THEME:GetPathG("_GradeDisplay Small/_ScreenSelectMusic","GoodFullCombo"));
								self:diffuse(GameColor.Judgment["JudgmentLine_W4"]);
								self:zoom(2.5);
								self:y(SCREEN_CENTER_Y+65);
							else
								self:Load(THEME:GetPathG("","_blank"));
								self:zoom(0);
								self:diffuse(1.0,1.0,1.0,0);
							end;
						else
							self:Load(THEME:GetPathG("","_blank"));
							self:zoom(0);
							self:diffuse(1.0,1.0,1.0,0);
						end;
					end;
				end;
			};
			LoadActor("calories");
			--[[
			LoadFont("Common Normal")..{
				InitCommand=function(self)
					self:Center();
					self:addy(100);
					local jud={};
					jud=GetSongJud(pn);
					self:diffuse(Color("Black"));
					self:settext(""..jud[1].."/"..jud[2].."/"..jud[3].."/"..jud[4].."/"..jud[5].."/"..jud[6].."/"..jud[7].."/"..jud[8]);
				end;
			};
			--]]
		};
		for i=1,#judtable do
			t[#t+1]=Def.ActorFrame{
				OnCommand=function(self)
					self:addy(-SCREEN_HEIGHT);
					self:decelerate(_TT.S_IN);
					self:addy(SCREEN_HEIGHT);
				end;
				OffCommand=function(self)
					self:accelerate(_TT.S_OUT);
					self:addy(SCREEN_HEIGHT);
				end;
				LoadFont("Common Normal")..{
					InitCommand=function(self)
						self:x((pn==PLAYER_1) and
							THEME:GetMetric("ScreenEvaluation",judtable[i].."NumberP1X")-40
							or THEME:GetMetric("ScreenEvaluation",judtable[i].."NumberP2X")+40);
						self:horizalign((pn==PLAYER_1) and right or left);
						self:y(THEME:GetMetric("ScreenEvaluation",judtable[i].."NumberP1Y"));
						self:diffuse(GameColor.Judgment["JudgmentLine_"..judtable[i]]);
						self:shadowlength(1);
						self:maxwidth(110/0.8);
						self:zoom(0.8);
						self:skewx(-0.1);
						self:settext(string.upper(_JudgementLabel("JudgmentLine_"..judtable[i]))..ExtraJudChar[judtable[i]]);
					end;
				};
			};
		end;
	end;
end;

t[#t+1]=LoadFallbackB();
return t